/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.debug.engine;

import frc.emul.api.engine.DebugEvent;
import frc.emul.api.engine.EngineMode;
import frc.emul.api.engine.EngineState;
import frc.emul.api.engine.IDebugEngine;
import frc.emul.api.engine.IDebugEventManager;
import frc.emul.api.engine.IDebugMemory;
import frc.emul.api.engine.IEngineBreakpoint;
import frc.emul.api.engine.IEngineBreakpointManager;
import frc.emul.api.engine.IStatus;
import frc.emul.config.Configuration;
import frc.emul.debug.breakpoints.StepReturnBreakpoint;
import frc.emul.debug.breakpoints.TemporaryBreakpoint;
import frc.emul.debug.breakpoints.VectrexBreakpointManager;
import frc.emul.debug.engine.StatusInfo;
import frc.emul.debug.model.DebugCore;
import frc.emul.mc6809.Instruction;
import frc.emul.mc6809.MC6809;
import frc.emul.mc6809.dasm.DasmUtils;
import frc.emul.util.Utils;
import frc.emul.vectrex.BreakpointException;
import frc.emul.vectrex.Vectrex;
import java.io.IOException;
import java.io.InputStream;

public class VectrexEngine
implements IDebugEngine {
    private static final int TOP_OF_STACK = 52202;
    private static final int PRIORITY = 5;
    private Object lock = new Lock();
    private EngineState state = EngineState.TERMINATED;
    private DebugEvent.Reason cause = DebugEvent.Reason.UNSPECIFIED;
    private EngineMode mode;
    private int stopAddr;
    private int exitCode;
    private final IEngineBreakpointManager bkptMgr;
    private final IDebugEventManager evtMgr;
    private final DebugCore core;
    private final DebugEngineThread worker;

    public VectrexEngine(Configuration configuration, IDebugEventManager iDebugEventManager) {
        this.core = new DebugCore(configuration);
        this.worker = new DebugEngineThread();
        this.bkptMgr = new VectrexBreakpointManager(this.core);
        this.evtMgr = iDebugEventManager;
    }

    public final Object getLock() {
        return this.lock;
    }

    public void loadSystemROM(InputStream inputStream) throws IOException {
        this.core.loadSystemROM(inputStream);
    }

    public void loadCartridgeROM(InputStream inputStream) throws IOException {
        this.core.loadCartridgeROM(inputStream);
    }

    public final void defineCartridgeRAM(int n, int n2) {
        this.core.defineCartridgeRAM(n, n2);
    }

    public void runVM() {
        this.core.initialise();
        this.state = EngineState.SUSPENDED;
        if (this.evtMgr != null) {
            this.evtMgr.fireCreateEvent(this, DebugEvent.Reason.CLIENT_REQUEST);
        }
    }

    public Vectrex getCore() {
        return this.core;
    }

    public EngineMode getMode() {
        return this.mode;
    }

    public EngineState getState() {
        return this.state;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public boolean isResuming() {
        return EngineState.RESUMING == this.state;
    }

    public boolean isRunning() {
        return EngineState.RUNNING == this.state;
    }

    public boolean isSuspending() {
        return EngineState.SUSPENDING == this.state;
    }

    public boolean isSuspended() {
        return EngineState.SUSPENDED == this.state;
    }

    public boolean isTerminating() {
        return EngineState.TERMINATING == this.state;
    }

    public boolean isTerminated() {
        return EngineState.TERMINATED == this.state;
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return this.isRunning();
    }

    public boolean canTerminate() {
        return this.isRunning() || this.isSuspended();
    }

    public boolean resume() {
        return this.resume(EngineMode.RUN, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean suspend() {
        Object object = this.getLock();
        synchronized (object) {
            block4: {
                if (this.canSuspend()) break block4;
                return false;
            }
            this.cause = DebugEvent.Reason.CLIENT_REQUEST;
            this.state = EngineState.SUSPENDING;
            this.core.suspend();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean terminate() {
        Object object = this.getLock();
        synchronized (object) {
            block6: {
                if (this.canTerminate()) break block6;
                return false;
            }
            this.cause = DebugEvent.Reason.CLIENT_REQUEST;
            if (this.isSuspended()) {
                this.terminated();
            } else {
                this.state = EngineState.TERMINATING;
                this.core.terminate();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean resume(EngineMode engineMode, int n) {
        Object object = this.getLock();
        synchronized (object) {
            block4: {
                if (this.canResume()) break block4;
                return false;
            }
            this.stopAddr = n;
            this.cause = engineMode.getResumeReason();
            this.state = EngineState.RESUMING;
            this.mode = engineMode;
            this.worker.schedule();
            return true;
        }
    }

    public IEngineBreakpointManager getBreakpointManager() {
        return this.bkptMgr;
    }

    public IDebugMemory getDebugMemory() {
        return this.core.getDebugMemory();
    }

    public boolean isStepping() {
        return (this.isRunning() || this.isResuming()) && this.mode.isStepping();
    }

    public boolean canStepRunTo(int n) {
        return this.canResume();
    }

    public boolean canStepInto() {
        return this.canResume();
    }

    public boolean canStepOver() {
        return this.canResume();
    }

    public boolean canStepReturn() {
        return this.canResume() && this.core.getCPU().getRegisters().S() != 52202;
    }

    public boolean stepRunTo(int n) {
        return this.resume(EngineMode.STEP_RUNTO, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stepInto() {
        Object object = this.getLock();
        synchronized (object) {
            return this.canStepInto() ? this.resume(EngineMode.STEP_IN, 0) : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stepOver() {
        Object object = this.getLock();
        synchronized (object) {
            return this.canStepOver() ? this.resume(EngineMode.STEP_OVER, 0) : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stepReturn() {
        Object object = this.getLock();
        synchronized (object) {
            return this.canStepReturn() ? this.resume(EngineMode.STEP_RETURN, 0) : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspended(IEngineBreakpoint iEngineBreakpoint) {
        Object object = this.getLock();
        synchronized (object) {
            this.cause = iEngineBreakpoint == null ? this.mode.getSuspendReason() : DebugEvent.Reason.BREAKPOINT;
            this.state = EngineState.SUSPENDED;
            this.mode = null;
            this.evtMgr.fireSuspendEvent(this, this.cause, iEngineBreakpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminated() {
        Object object = this.getLock();
        synchronized (object) {
            this.state = EngineState.TERMINATED;
            this.mode = null;
            this.evtMgr.fireTerminateEvent(this, this.cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resumed() {
        Object object = this.getLock();
        synchronized (object) {
            this.state = EngineState.RUNNING;
            if (this.mode == null) {
                throw new IllegalStateException("EngineMode should not be null when resumed.");
            }
            this.evtMgr.fireResumeEvent(this, this.cause);
        }
    }

    protected boolean prepareStepping() {
        int n;
        int n2;
        Object object;
        EngineMode engineMode = this.mode;
        this.getBreakpointManager().resetBreakpoints();
        this.getDebugMemory().setMonitoringBreakpoints(true);
        if (engineMode == EngineMode.STEP_IN) {
            return true;
        }
        if (engineMode == EngineMode.STEP_RUNTO) {
            this.getBreakpointManager().add(new TemporaryBreakpoint(this.stopAddr));
            engineMode = EngineMode.RUN;
        }
        MC6809 mC6809 = this.core.getCPU();
        if (engineMode == EngineMode.STEP_RETURN) {
            object = this.core.getMemory();
            n2 = this.core.getCPU().getRegisters().S();
            n = n2 + 40;
            int n3 = 0;
            if (n2 <= 52202 && n >= 52202) {
                n = 52201;
            }
            while (n2 < n && object.canRead(n2, 2)) {
                int n4 = object.readU16(n2);
                if (object.canExecute(n4, 2)) {
                    this.getBreakpointManager().add(new StepReturnBreakpoint(n4, n2 + 2));
                    ++n3;
                }
                ++n2;
            }
            if (n3 >= 1) {
                return false;
            }
            engineMode = EngineMode.STEP_OVER;
        }
        if (engineMode == EngineMode.STEP_OVER) {
            object = mC6809.getCurrentInstruction();
            if (DasmUtils.isStepInOpcode((Instruction)object)) {
                n2 = mC6809.getCurrentPC();
                n = DasmUtils.getInstructionEndAddress((Instruction)object, n2, mC6809.getMemory());
                this.getBreakpointManager().add(new TemporaryBreakpoint(n));
                return false;
            }
            return true;
        }
        if (engineMode == EngineMode.RUN) {
            return false;
        }
        throw new IllegalStateException("Unsupported Engine Mode : " + (Object)((Object)engineMode));
    }

    public static final StatusInfo buildVmError(Vectrex vectrex) {
        Throwable throwable = vectrex.getLastError();
        StatusInfo statusInfo = StatusInfo.error("Internal Error in the Vectrex VM, terminating emulation.", throwable);
        statusInfo.addChild(StatusInfo.info("Registers: " + Utils.dumpRegs(vectrex.getCPU())));
        if (throwable != null && throwable.getCause() != null) {
            while (throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
            statusInfo.addChild(StatusInfo.error("VM Error root cause", throwable));
        }
        try {
            statusInfo.addChild(StatusInfo.info("Stack: " + Utils.stackContent(vectrex.getCPU(), 32)));
        }
        catch (Exception exception) {}
        return statusInfo;
    }

    public static final void log(IStatus iStatus) {
        System.out.println(" _________________________________");
        System.out.println("| Severity  = " + iStatus.getSeverity());
        System.out.println("| Code      = " + iStatus.getCode());
        System.out.println("| Message   = " + iStatus.getMessage());
        if (iStatus.getException() != null) {
            System.out.print("| ");
            iStatus.getException().printStackTrace(System.out);
        }
    }

    private class DebugEngineThread
    extends Thread {
        private boolean request;

        DebugEngineThread() {
            super("ParaJVE Debug Engine VM");
            this.setPriority(5);
            this.start();
        }

        public synchronized void schedule() {
            this.request = true;
            this.notifyAll();
        }

        public synchronized void run() {
            while (true) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
                if (!this.request) continue;
                this.request = false;
                this.process();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void process() {
            block32: {
                IEngineBreakpoint iEngineBreakpoint;
                block31: {
                    iEngineBreakpoint = null;
                    try {
                        try {
                            boolean bl;
                            block30: {
                                VectrexEngine.this.resumed();
                                try {
                                    try {
                                        bl = VectrexEngine.this.prepareStepping() ? VectrexEngine.this.core.step(1) : VectrexEngine.this.core.resume();
                                    }
                                    catch (BreakpointException breakpointException) {
                                        iEngineBreakpoint = breakpointException.isTemporaryBreakpoint() ? null : breakpointException.getBreakpoint();
                                        bl = true;
                                        VectrexEngine.this.getDebugMemory().setMonitoringBreakpoints(false);
                                        VectrexEngine.this.getBreakpointManager().removeTemporaryBreakpoints();
                                        break block30;
                                    }
                                }
                                catch (Throwable throwable) {
                                    VectrexEngine.this.getDebugMemory().setMonitoringBreakpoints(false);
                                    VectrexEngine.this.getBreakpointManager().removeTemporaryBreakpoints();
                                    throw throwable;
                                }
                                VectrexEngine.this.getDebugMemory().setMonitoringBreakpoints(false);
                                VectrexEngine.this.getBreakpointManager().removeTemporaryBreakpoints();
                            }
                            if (bl) break block31;
                            Object object = VectrexEngine.this.getLock();
                            synchronized (object) {
                                VectrexEngine.this.state = EngineState.TERMINATING;
                                VectrexEngine.this.cause = DebugEvent.Reason.ENGINE_ERROR;
                                VectrexEngine.log(VectrexEngine.buildVmError(VectrexEngine.this.core));
                                VectrexEngine.this.exitCode = -1;
                            }
                        }
                        catch (Exception exception) {
                            Object object = VectrexEngine.this.getLock();
                            synchronized (object) {
                                VectrexEngine.this.state = EngineState.TERMINATING;
                                VectrexEngine.this.cause = DebugEvent.Reason.ENGINE_ERROR;
                            }
                            exception.printStackTrace(System.err);
                            System.err.println("Internal Error in Vectrex VM, terminating emulation.");
                            VectrexEngine.this.exitCode = -2;
                            Object object2 = VectrexEngine.this.getLock();
                            synchronized (object2) {
                                if (VectrexEngine.this.state == EngineState.TERMINATING) {
                                    VectrexEngine.this.terminated();
                                } else {
                                    VectrexEngine.this.suspended(iEngineBreakpoint);
                                }
                                break block32;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object object = VectrexEngine.this.getLock();
                        synchronized (object) {
                            if (VectrexEngine.this.state == EngineState.TERMINATING) {
                                VectrexEngine.this.terminated();
                            } else {
                                VectrexEngine.this.suspended(iEngineBreakpoint);
                            }
                        }
                        throw throwable;
                    }
                }
                Object object = VectrexEngine.this.getLock();
                synchronized (object) {
                    if (VectrexEngine.this.state == EngineState.TERMINATING) {
                        VectrexEngine.this.terminated();
                    } else {
                        VectrexEngine.this.suspended(iEngineBreakpoint);
                    }
                }
            }
        }
    }

    final class Lock {
        Lock() {
        }
    }
}

